-- SQLite DDL File
-- GOMA DDL Generator Version: 2.5, Build: 184 (SchemaGen2 V. 1.0, Build: 184)

-- begin cleanup script part
-- begin table cleanup script part


-- end

-- end table cleanup script part

-- begin table-creation script part
-- create table for persistent class Node
CREATE TABLE Node (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	ParentNode_oid	VARCHAR(36),
	DefaultSystemPartner_oid	VARCHAR(36),
	DefaultTemplatePartner_oid	VARCHAR(36),
	Level	INTEGER DEFAULT -1,
	CONSTRAINT PKEY_Node_Oid PRIMARY KEY (Oid));



-- create table for persistent class User
CREATE TABLE eBissUser (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	Password	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	ViewMode	INTEGER,
	NotificationAddress	VARCHAR(254),
	CONSTRAINT PKEY_eBissUser_Oid PRIMARY KEY (Oid));


-- create table for persistent class AccessRight
CREATE TABLE AccessRight (
	Oid	VARCHAR(36) NOT NULL,
	CanCreateUsers	BIT,
	Node_oid	VARCHAR(36) NOT NULL,
	User_oid	VARCHAR(36) NOT NULL,
	CanCreateNodes	BIT,
	CanEditJobs	BIT,
	CanCreateJobs	BIT,
	CanChangeSelf	BIT,
	CanCreateChannels	BIT,
	CanCreateTradingPartners	BIT,
	CanCreateSystemPartners	BIT,
	CanCreateMaps BIT,
	CanEditMaps BIT,
	CanCreateRepository  BIT,
	CanCreateMessageBox  BIT,
	CanDeleteMaps  BIT,
	CanDeleteJobs  BIT,
	CanDeleteNodes  BIT,
	CanDeleteRepository  BIT,
	CanDeleteMessageBox  BIT,
	CanDeleteChannel BIT,
	CanDeletePartner BIT,
	CONSTRAINT PKEY_AccessRight_Oid PRIMARY KEY (Oid),
	CONSTRAINT UNIQUE_AccessRight_UniqueNode UNIQUE (User_oid, Node_oid));


-- create table for persistent class JobDef
CREATE TABLE JobDef (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	Owner_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	Flags	INTEGER,
	Description	VARCHAR(256),
	JobBytes	BLOB,
	VersionString	VARCHAR(64),
	LastModified	DATETIME,
	LastModifiedBy_oid	VARCHAR(36),
	IsPublic	BIT,
	CONSTRAINT PKEY_JobDef_Oid PRIMARY KEY (Oid));


-- create table for persistent class RuntimeSession
CREATE TABLE RuntimeSession (
	Oid	VARCHAR(36) NOT NULL,
	StartDate	DATETIME,
	EndDate	DATETIME,
	State	INTEGER,
	User_oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_RuntimeSession_Oid PRIMARY KEY (Oid));


-- create table for persistent class AddressBase
CREATE TABLE AddressBase (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	AddressType	INTEGER,
	Uri	VARCHAR(254),
	Options	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	Partner_oid	VARCHAR(36) NOT NULL,
	IsDefault	BIT,
	CompressionMode	INTEGER,
	CONSTRAINT PKEY_AddressBase_Oid PRIMARY KEY (Oid));


CREATE TABLE TypeSet_AddressBase (
	TypeSet_oid	VARCHAR(36) NOT NULL,
	AddressBase_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_TypeSet_AddressBase_TypeSet_oid_AddressBase_oid PRIMARY KEY (TypeSet_oid, AddressBase_oid));


-- create table for persistent class MessageBox
CREATE TABLE MessageBox (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	BoxType	INTEGER,
	FilterMaxState	INTEGER,
	FilterMinTaskState	INTEGER,
	FilterNewerThanMinutes	INTEGER,
	CONSTRAINT PKEY_MessageBox_Oid PRIMARY KEY (Oid));


-- create table for persistent class Message
CREATE TABLE Message (
	Oid	VARCHAR(36) NOT NULL,
	_Key	VARCHAR(64),
	Subject	VARCHAR(256),
	RefExternal	VARCHAR(128),
	ComAddressType	INTEGER,
	ComRef	VARCHAR(128),
	ComSender	VARCHAR(128),
	ComReceiver	VARCHAR(128),
	Analyzed	BIT,
	EntryDate	DATETIME,
	EntryPath	VARCHAR(64),
	DelegatedJob_oid	VARCHAR(36),
	MessageBox_oid	VARCHAR(36) NOT NULL,
	Size	INTEGER,
	OwnLocation_oid	VARCHAR(36),
	Partner_oid	VARCHAR(36),
	Direction	INTEGER NOT NULL,
	ComNotificationReceiver	VARCHAR(128),
	ComMd5HashBase64	VARCHAR(64),
	ComSha1HashBase64	VARCHAR(64),
	NotificationRequested	BIT,
	IsNotificationMessage	BIT,
	State	INTEGER,
	TaskState	INTEGER,
	LevelTaskState	INTEGER,
	CONSTRAINT PKEY_Message_Oid PRIMARY KEY (Oid));


CREATE TABLE ProcessInstance_Message (
	ProcessInstance_oid	VARCHAR(36) NOT NULL,
	Message_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_ProcessInstance_Message_ProcessInstance_oid_Message_oid PRIMARY KEY (ProcessInstance_oid, Message_oid));


-- create table for persistent class Attachment
CREATE TABLE Attachment (
	Oid	VARCHAR(36) NOT NULL,
	Message_oid	VARCHAR(36) NOT NULL,
	Filename	VARCHAR(254),
	EdiFileType	INTEGER,
	EntityAnalyzer_oid	VARCHAR(36),
	Size	INTEGER,
	State	INTEGER,
	TaskState	INTEGER,
	SequenceNumber	INTEGER,
	LevelTaskState	INTEGER,
	CONSTRAINT PKEY_Attachment_Oid PRIMARY KEY (Oid));


-- create table for persistent class Interchange
CREATE TABLE Interchange (
	Oid	VARCHAR(36) NOT NULL,
	Attachment_oid	VARCHAR(36) NOT NULL,
	EdiSender	VARCHAR(64),
	EdiRecipient	VARCHAR(64),
	EdiReference	VARCHAR(64),
	Partner_oid	VARCHAR(36),
	OwnLocation_oid	VARCHAR(36),
	RawContent	VARCHAR(4096),
	State	INTEGER,
	TaskState	INTEGER,
	SequenceNumber	INTEGER,
	StartOffset	INTEGER,
	LevelTaskState	INTEGER,
	CONSTRAINT PKEY_Interchange_Oid PRIMARY KEY (Oid));


-- create table for persistent class Document
CREATE TABLE Document (
	Oid	VARCHAR(36) NOT NULL,
	Interchange_oid	VARCHAR(36) NOT NULL,
	Message_oid	VARCHAR(36) NOT NULL,
	DocType	VARCHAR(64),
	DocSubType	VARCHAR(64),
	StandardMain	VARCHAR(64),
	StandardSub	VARCHAR(64),
	StandardVersion	VARCHAR(64),
	CommunicationId	VARCHAR(64),
	DocNumber	VARCHAR(64),
	DocDate	VARCHAR(64),
	State	INTEGER,
	EntityType_oid	VARCHAR(36),
	OriginDocument_oid	VARCHAR(36),
	TaskState	INTEGER,
	SequenceNumber	INTEGER,
	StartOffset	INTEGER,
	LevelTaskState	INTEGER,
	SystemLocation_oid	VARCHAR(36),
	PartnerLocation_oid	VARCHAR(36),
	CONSTRAINT PKEY_Document_Oid PRIMARY KEY (Oid));


-- create table for persistent class MapDef
CREATE TABLE MapDef (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	Description	VARCHAR(256),
	VersionString	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	Owner_oid	VARCHAR(36) NOT NULL,
	MapBytes	BLOB,
	LastModified	DATETIME,
	LastModifiedBy_oid	VARCHAR(36),
	SourceTypeName	VARCHAR(64),
	TargetTypeName	VARCHAR(64),
	IsPublic	BIT,
	CONSTRAINT PKEY_MapDef_Oid PRIMARY KEY (Oid));


-- create table for persistent class LookupTableType
CREATE TABLE LookupTableType (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	ValueProvider_oid	VARCHAR(36) NOT NULL,
	AutoAddNewTables	BIT,
	AutoAddKeysDefault	BIT,
	CONSTRAINT PKEY_LookupTableType_Oid PRIMARY KEY (Oid));


-- create table for persistent class LookupTable
CREATE TABLE LookupTable (
	Oid	VARCHAR(36) NOT NULL,
	LookupTableType_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	_Public	BIT,
	AutoAddKeys	BIT,
	CONSTRAINT PKEY_LookupTable_Oid PRIMARY KEY (Oid));


-- create table for persistent class LookupTableEntry
CREATE TABLE LookupTableEntry (
	Oid	VARCHAR(36) NOT NULL,
	LookupTable_oid	VARCHAR(36) NOT NULL,
	_Key	VARCHAR(64),
	Description	VARCHAR(128),
	ValueEntry_oid	VARCHAR(36),
	LastRequested	DATETIME,
	CONSTRAINT PKEY_LookupTableEntry_Oid PRIMARY KEY (Oid));


-- create table for persistent class LookupTableValueProvider
CREATE TABLE LookupTableValueProvider (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	BackendLookupProviderTypeName	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	BackendLookupProviderReference	VARCHAR(64),
	CONSTRAINT PKEY_LookupTableValueProvider_Oid PRIMARY KEY (Oid));


-- create table for persistent class LookupTableValueProviderEntry
CREATE TABLE LookupTableValueProviderEntry (
	Oid	VARCHAR(36) NOT NULL,
	ValueProvider_oid	VARCHAR(36) NOT NULL,
	Val	VARCHAR(64),
	Description	VARCHAR(128),
	CONSTRAINT PKEY_LookupTableValueProviderEntry_Oid PRIMARY KEY (Oid));


-- create table for persistent class Partner
CREATE TABLE Partner (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	TNr	VARCHAR(64),
	Memo	VARCHAR(2048),
	Type	INTEGER NOT NULL,
	LastSentInterchangeReference	INTEGER,
	LastSentDocumentReference	INTEGER,
	LastReceivedInterchangeReference	INTEGER,
	LastReceivedDocumentReference	INTEGER,
	Channel_oid	VARCHAR(36),
	Preislinien_oid VARCHAR(36),
	Containerizer_oid	VARCHAR(36),
	MainLocation_oid	VARCHAR(36),
	Node_oid	VARCHAR(36) NOT NULL,
	Template_oid	VARCHAR(36),
	PartnerLanguage_oid VARCHAR(36),
	CONSTRAINT PKEY_Partner_Oid PRIMARY KEY (Oid));


-- create table for persistent class Article
CREATE TABLE Article (
	Oid	VARCHAR(36) NOT NULL,
	SupplierGLN	VARCHAR(14),
	ManufacturerGLN	VARCHAR(14),
	BuyerGLN	VARCHAR(14),
	ArticleNumber	VARCHAR(40),
	Node_oid	VARCHAR(36) NOT NULL,
	Location_oid	VARCHAR(36) NOT NULL,
	LastChange	DATETIME,
	LastReceiveDate DATETIME,
	CONSTRAINT PKEY_Article_Oid PRIMARY KEY (Oid));


-- create table for persistent class ArticleDetail
CREATE TABLE ArticleDetail (
	Oid	VARCHAR(36) NOT NULL,
	Article_oid	VARCHAR(36) NOT NULL,
	Color	VARCHAR(40),
	Size	VARCHAR(64),
	Size2	VARCHAR(40),
	ProductGroup	VARCHAR(40),
	ArticleDescription	VARCHAR(64),
	ArticleNumber	VARCHAR(40),
	BrandName	VARCHAR(40),
	SubBrandName	VARCHAR(40),
	CustomsItemNumber	VARCHAR(20),
	OriginCountry	VARCHAR(3),
	Season	VARCHAR(40),
	ArticleClass	VARCHAR(3),
	MinimumOrderQuantity	INTEGER,
	PackagingQuantity	INTEGER,
	ArticleDetailPreislinien_oid VARCHAR(36),
	EffectivePurchasePrice	INTEGER,
	ListPurchasePrice	INTEGER,
	PurchasePriceCurrency	VARCHAR(3),
	SuggestedRetailPrice	INTEGER,
	RetailPriceCurrency	VARCHAR(3),
	ValidFrom	DATETIME,
	ValidTo	DATETIME,
	CreationTime	DATETIME,
	ModificationTime	DATETIME,
	LastTouched	DATETIME,
	BackendReference	VARCHAR(40),
	BackendAccepted	BIT,
	BackendAcceptedTime	DATETIME,
	Ean	VARCHAR(20),
	DTBProductGroup	INTEGER,
	BTEProductGroup	INTEGER,
	PosAction	INTEGER,
	Node_oid	VARCHAR(36) NOT NULL,
	ColorAttribute_oid	VARCHAR(36),
	SizeAttribute_oid	VARCHAR(36),
	ProductGroupAttribute_oid	VARCHAR(36),
	StandardProductGroup	VARCHAR(64),
	StandardColor	VARCHAR(64),
	StandardSize	VARCHAR(64),
	AdditionalScanCode	VARCHAR(25),
	ExtensionField1	VARCHAR(64),
	ExtensionField2	VARCHAR(64),
	FashionTheme VARCHAR(40),
	CONSTRAINT PKEY_ArticleDetail_Oid PRIMARY KEY (Oid));


-- create table for persistent class DocMatch
CREATE TABLE DocMatch (
	Oid	VARCHAR(36) NOT NULL,
	Partner_oid	VARCHAR(36) NOT NULL,
	DocType	VARCHAR(64),
	DocSubType	VARCHAR(64),
	StandardMain	VARCHAR(64),
	StandardSub	VARCHAR(64),
	StandardVersion	VARCHAR(64),
	PartnerMatchString	VARCHAR(64),
	StandardMapping_oid	VARCHAR(36),
	SpecialMapping_oid	VARCHAR(36),
	CONSTRAINT PKEY_DocMatch_Oid PRIMARY KEY (Oid));


-- create table for persistent class ArticleSubscription
CREATE TABLE ArticleSubscription (
	Oid	VARCHAR(36) NOT NULL,
	FieldName	VARCHAR(64),
	Value	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	Location_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_ArticleSubscription_Oid PRIMARY KEY (Oid));


-- create table for persistent class Task
CREATE TABLE Task (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	ResponsibleUser_oid	VARCHAR(36),
	TaskMessage	INTEGER,
	ProcessInstance_oid	VARCHAR(36),
	ResolvObjectReference_oid	VARCHAR(36),
	Done	BIT,
	CreationDate	DATETIME,
	DoneDate	DATETIME,
	Info	TEXT,
	NotificationSent	BIT,
	CONSTRAINT PKEY_Task_Oid PRIMARY KEY (Oid));


CREATE TABLE Task_ObjectReference (
	Task_oid	VARCHAR(36) NOT NULL,
	ObjectReference_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_Task_ObjectReference_Task_oid_ObjectReference_oid PRIMARY KEY (Task_oid, ObjectReference_oid));


-- create table for persistent class ProcessInstance
CREATE TABLE ProcessInstance (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	NumOpenEntities	INTEGER,
	State	INTEGER,
	StartDate	DATETIME,
	LastTouched	DATETIME,
	Name	VARCHAR(64),
	RuntimeSession_oid	VARCHAR(36) NOT NULL,
	EndDate	DATETIME,
	ProcessLog	VARCHAR(64),
	CONSTRAINT PKEY_ProcessInstance_Oid PRIMARY KEY (Oid));


-- create table for persistent class ObjectReference
CREATE TABLE ObjectReference (
	Oid	VARCHAR(36) NOT NULL,
	TypeName	VARCHAR(64),
	RefOid	VARCHAR(36),
	CONSTRAINT PKEY_ObjectReference_Oid PRIMARY KEY (Oid));


-- create table for persistent class ScheduleEvent
CREATE TABLE ScheduleEvent (
	Oid	VARCHAR(36) NOT NULL,
	NextTime	DATETIME,
	CoreEventListener_oid	VARCHAR(36),
	CONSTRAINT PKEY_ScheduleEvent_Oid PRIMARY KEY (Oid));


-- create table for persistent class ScheduleTime
CREATE TABLE ScheduleTime (
	Oid	VARCHAR(36) NOT NULL,
	ScheduleEvent_oid	VARCHAR(36) NOT NULL,
	IsException	BIT,
	Month	INTEGER,
	DayOfMonth	INTEGER,
	DayOfWeek	INTEGER,
	Hour	INTEGER,
	Minute	INTEGER,
	CONSTRAINT PKEY_ScheduleTime_Oid PRIMARY KEY (Oid));


-- create table for persistent class PortEventListener
CREATE TABLE PortEventListener (
	Oid	VARCHAR(36) NOT NULL,
	Port	INTEGER NOT NULL,
	CoreEventListener_oid	VARCHAR(36),
	BindInterfaceIP	VARCHAR(64),
	CONSTRAINT PKEY_PortEventListener_Oid PRIMARY KEY (Oid));


-- create table for persistent class CoreEventListener
CREATE TABLE CoreEventListener (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(120) NOT NULL,
	Active	BIT,
	JobDef_oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	ListenerTypeName	VARCHAR(64) NOT NULL,
	LastTimeTriggered	DATETIME,
	User_oid	VARCHAR(36) NOT NULL,
	LastChanged	DATETIME,
	LastChangeSessionId	VARCHAR(36),
	CONSTRAINT PKEY_CoreEventListener_Oid PRIMARY KEY (Oid));


-- create table for persistent class PortAccessRule
CREATE TABLE PortAccessRule (
	Oid	VARCHAR(36) NOT NULL,
	PortEventListener_oid	VARCHAR(36) NOT NULL,
	IsException	BIT,
	Host	VARCHAR(64),
	Netmask	VARCHAR(64),
	CONSTRAINT PKEY_PortAccessRule_Oid PRIMARY KEY (Oid));


-- create table for persistent class CoreChannel
CREATE TABLE CoreChannel (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	ChannelTypeName	VARCHAR(64) NOT NULL,
	MessageBox_oid	VARCHAR(36) NOT NULL,
	ChannelDirection	INTEGER NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	MessageDirection	INTEGER NOT NULL,
	SenderValidation	INTEGER,
	RecipientValidation	INTEGER,
	DefaultSender_oid	VARCHAR(36),
	DefaultRecipient_oid	VARCHAR(36),
	AutoUncompress	INTEGER,
	dbPublic	BIT,
	CONSTRAINT PKEY_CoreChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class HttpReceiveChannel
CREATE TABLE HttpReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	URI	VARCHAR(64),
	UseTLS	BIT,
	CertificateFile	VARCHAR(64),
	PositiveAnswerDocument	TEXT,
	SendAnswerDocuments	BIT,
	NegativeAnswerDocument	TEXT,
	ProxyBehaviour	INTEGER,
	CONSTRAINT PKEY_HttpReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class TypeRepository
CREATE TABLE TypeRepository (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) DEFAULT "Repository" NOT NULL,
	IsPublic	BIT,
	CONSTRAINT PKEY_TypeRepository_Oid PRIMARY KEY (Oid));


-- create table for persistent class FileTypeRecognizer
CREATE TABLE FileTypeRecognizer (
	Oid	VARCHAR(36) NOT NULL,
	TypeRepository_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	Active	BIT NOT NULL,
	RecognizerTypeName	VARCHAR(64),
	Direction	INTEGER NOT NULL,
	FileMask	VARCHAR(64),
	MatchString	VARCHAR(100),
	CharacterEncoding	VARCHAR(64),
	CONSTRAINT PKEY_FileTypeRecognizer_Oid PRIMARY KEY (Oid));


-- create table for persistent class EntityAnalyzer
CREATE TABLE EntityAnalyzer (
	Oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	AnalyzerTypeName	VARCHAR(64) NOT NULL,
	Repository_oid	VARCHAR(36) NOT NULL,
	Recognizer_oid	VARCHAR(36) NOT NULL,
	ObjectReaderTypeName	VARCHAR(64),
	CoreObjectReader_oid	VARCHAR(36) NOT NULL,
	PartnerIdentification	INTEGER,
	UseDifferentIdentificationForSystemPartner	BIT,
	SystemPartnerIdentification	INTEGER,
	CONSTRAINT PKEY_EntityAnalyzer_Oid PRIMARY KEY (Oid));


CREATE TABLE EntityAnalyzer_EntityType (
	EntityAnalyzer_oid	VARCHAR(36) NOT NULL,
	EntityType_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_EntityAnalyzer_EntityType_EntityAnalyzer_oid_EntityType_oid PRIMARY KEY (EntityAnalyzer_oid, EntityType_oid));


-- create table for persistent class EntityType
CREATE TABLE EntityType (
	Oid	VARCHAR(36) NOT NULL,
	Repository_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	EntityTypeName	VARCHAR(64) NOT NULL,
	DefaultContainerizer_oid	VARCHAR(36),
	DefaultObjectWriter_oid	VARCHAR(36),
	DefaultObjectReader_oid	VARCHAR(36),
	DocumentSubType	VARCHAR(64),
	CONSTRAINT PKEY_EntityType_Oid PRIMARY KEY (Oid),
	CONSTRAINT UNIQUE_EntityType_Types UNIQUE (Repository_oid, EntityTypeName, DocumentSubType));


-- create table for persistent class EntityContainerizer
CREATE TABLE EntityContainerizer (
	Oid	VARCHAR(36) NOT NULL,
	Repository_oid	VARCHAR(36) NOT NULL,
	ContainerizerTypeName	VARCHAR(64) NOT NULL,
	Scope	INTEGER NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36),
	FNameGenFilenameGeneration	INTEGER,
	FNameGenFilenameMask	VARCHAR(256),
	FNameGenUseBadCharReplacing	BIT,
	FNameGenBadCharReplacingMethod	INTEGER,
	SNameGenSubjectGeneration	INTEGER,
	SNameGenSubjectMask	VARCHAR(256),
	CONSTRAINT PKEY_EntityContainerizer_Oid PRIMARY KEY (Oid));


-- create table for persistent class TypeSet
CREATE TABLE TypeSet (
	Oid	VARCHAR(36) NOT NULL,
	Partner_oid	VARCHAR(36) NOT NULL,
	Direction	INTEGER,
	Type_oid	VARCHAR(36),
	TargetType_oid	VARCHAR(36),
	CoreChannel_oid	VARCHAR(36),
	EntityContainerizer_oid	VARCHAR(36),
	Mapping_oid	VARCHAR(36),
	CONSTRAINT PKEY_TypeSet_Oid PRIMARY KEY (Oid));


-- create table for persistent class HttpSendChannel
CREATE TABLE HttpSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	Authenticate	BIT,
	AuthenticateUser	VARCHAR(64),
	AuthenticatePassword	VARCHAR(64),
	AuthenticateDomain	VARCHAR(64),
	MimeType	VARCHAR(64),
	HttpVersion	VARCHAR(5),
	BaseURI	VARCHAR(64),
	CONSTRAINT PKEY_HttpSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ediBOXReceiveChannel
CREATE TABLE ediBOXReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	SlotType	INTEGER,
	SlotName	VARCHAR(64),
	CONSTRAINT PKEY_ediBOXReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ediBOXSendChannel
CREATE TABLE ediBOXSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	SlotType	INTEGER,
	SlotName	VARCHAR(64),
	CONSTRAINT PKEY_ediBOXSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class FileEventListener
CREATE TABLE FileEventListener (
	Oid	VARCHAR(36) NOT NULL,
	CoreEventListener_oid	VARCHAR(36),
	WatchMask	VARCHAR(64) NOT NULL,
	CONSTRAINT PKEY_FileEventListener_Oid PRIMARY KEY (Oid));


-- create table for persistent class Pop3ReceiveChannel
CREATE TABLE Pop3ReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	Username	VARCHAR(64) NOT NULL,
	Password	VARCHAR(64),
	Host	VARCHAR(64) NOT NULL,
	Port	INTEGER NOT NULL,
	Authentification	INTEGER NOT NULL,
	DeleteReceivedMessages	BIT,
	SslHandling	INTEGER,
	SslClientCertPfxFile	VARCHAR(64),
	SslClientCertPfxPassword	VARCHAR(64),
	CONSTRAINT PKEY_Pop3ReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class CoreObjectReader
CREATE TABLE CoreObjectReader (
	Oid	VARCHAR(36) NOT NULL,
	Repository_oid	VARCHAR(36) NOT NULL,
	CharacterEncoding	VARCHAR(64),
	Name	VARCHAR(64),
	ReaderConfigTypeName	VARCHAR(64) NOT NULL,
	CONSTRAINT PKEY_CoreObjectReader_Oid PRIMARY KEY (Oid));


-- create table for persistent class EdifactReaderConfig
CREATE TABLE EdifactReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	IgnoreUnknownUnUsSegments BIT,
	CoreObjectReader_oid	VARCHAR(36),
	CONSTRAINT PKEY_EdifactReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class SdfReaderConfig
CREATE TABLE SdfReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	Seperator	INTEGER,
	RecordTagPosition	INTEGER,
	ExtendedParser	BIT,
	OpenBrackets	VARCHAR(64),
	CloseBrackets	VARCHAR(64),
	EscapeChars	VARCHAR(64),
	AdditionalSeperators	VARCHAR(64),
	CONSTRAINT PKEY_SdfReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class HarddiskSendChannel
CREATE TABLE HarddiskSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	OutputPath	VARCHAR(256) NOT NULL,
	FileNameHandling	INTEGER,
	FileExistsHandling	INTEGER,
	CONSTRAINT PKEY_HarddiskSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class HarddiskReceiveChannel
CREATE TABLE HarddiskReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	InputPath	VARCHAR(256) NOT NULL,
	DeleteAcceptedFiles	BIT,
	InputFileMask	VARCHAR(64),
	FileHandling	INTEGER,
	MoveToPath	varchar(256),
	CONSTRAINT PKEY_HarddiskReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class SmtpSendChannel
CREATE TABLE SmtpSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	Username	VARCHAR(64),
	Password	VARCHAR(64),
	Host	VARCHAR(64) NOT NULL,
	Port	INTEGER NOT NULL,
	Authentification	INTEGER NOT NULL,
	MailFrom	VARCHAR(64),
	SendSingleAttachmentsAsBody	BIT,
	RequestNotification	INTEGER,
	NotificationHash	INTEGER,
	UseSenderAddressAsFrom	BIT,
	SslHandling	INTEGER,
	SslClientCertPfxFile	VARCHAR(64),
	SslClientCertPfxPassword	VARCHAR(64),
	CONSTRAINT PKEY_SmtpSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class FixedLengthReaderConfig
CREATE TABLE FixedLengthReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	RecordTagLength	INTEGER,
	RecordTagPosition	INTEGER,
	SearchPartial	BIT,
	CONSTRAINT PKEY_FixedLengthReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class XmlReaderConfig
CREATE TABLE XmlReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	CONSTRAINT PKEY_XmlReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class CoreObjectWriter
CREATE TABLE CoreObjectWriter (
	Oid	VARCHAR(36) NOT NULL,
	Repository_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64),
	WriterConfigTypeName	VARCHAR(64) NOT NULL,
	CharacterEncoding	VARCHAR(64),
	CONSTRAINT PKEY_CoreObjectWriter_Oid PRIMARY KEY (Oid));


-- create table for persistent class EdifactWriterConfig
CREATE TABLE EdifactWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36),
	WriteLinebreak	BIT,
	ContainerizationSuppressUNA	BIT,
	CONSTRAINT PKEY_EdifactWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class SdfWriterConfig
CREATE TABLE SdfWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	Seperator	INTEGER,
	CONSTRAINT PKEY_SdfWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class FixedLengthWriterConfig
CREATE TABLE FixedLengthWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_FixedLengthWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class XmlWriterConfig
CREATE TABLE XmlWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	XMLBehaviour	INTEGER,
	ContainerizationRootPath	VARCHAR(64),
	SupressXmlStandAlone	BIT,
	WriteEmptyTag BIT,
	CONSTRAINT PKEY_XmlWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class SapIDocWriterConfig
CREATE TABLE SapIDocWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_SapIDocWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class SapIDocReaderConfig
CREATE TABLE SapIDocReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	CONSTRAINT PKEY_SapIDocReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class Location
CREATE TABLE Location (
	Oid	VARCHAR(36) NOT NULL,
	Partner_oid	VARCHAR(36) NOT NULL,
	Type	INTEGER NOT NULL,
	BackendReference_oid	VARCHAR(36),
	GLN	VARCHAR(64),
	Name	VARCHAR(64),
	Name2	VARCHAR(64),
	Street	VARCHAR(64),
	Street2	VARCHAR(64),
	ZipCode	VARCHAR(12),
	City	VARCHAR(64),
	Country	VARCHAR(64),
	Notes	VARCHAR(2048),
	Node_oid	VARCHAR(36),
	PartnerType	INTEGER,
	CONSTRAINT PKEY_Location_Oid PRIMARY KEY (Oid));


-- create table for persistent class LocationLookup
CREATE TABLE LocationLookup (
	Oid	VARCHAR(36) NOT NULL,
	Location_oid	VARCHAR(36) NOT NULL,
	TableType_oid	VARCHAR(36) NOT NULL,
	Table_oid	VARCHAR(36),
	Enabled	BIT,
	ValueRequired	BIT,
	AddNewKeys	BIT,
	CONSTRAINT PKEY_LocationLookup_Oid PRIMARY KEY (Oid));


-- create table for persistent class AS2ReceiveChannel
CREATE TABLE AS2ReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	AS2LogPath	VARCHAR(64),
	SignerCertCsrFile	VARCHAR(64),
	OwnCertPfxFile	VARCHAR(64),
	OwnCertPassword	VARCHAR(64),
	OwnCertSubject	VARCHAR(64),
	UseSsl	BIT,
	SslServerCertPfxFile	VARCHAR(64),
	SslServerCertPassword	VARCHAR(64),
	CONSTRAINT PKEY_AS2ReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class AS2SendChannel
CREATE TABLE AS2SendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	Url	VARCHAR(254) NOT NULL,
	AS2Sender	VARCHAR(64),
	ContentType	VARCHAR(64),
	UseSenderAddressAsFrom	BIT,
	AS2LogPath	VARCHAR(64),
	RequestMDNTo	VARCHAR(64),
	SendFromAnToHeaders	BIT,
	AsynchronousReceiptTo	VARCHAR(64),
	UseInternalZLibCompression	BIT,
	RequestSignedMdn	BIT,
	SigningCertPfxFile	VARCHAR(64),
	SigningCertPassword	VARCHAR(64),
	SslClientCertPfxFile	VARCHAR(64),
	SslClientCertPassword	VARCHAR(64),
	RecipientCertCerFile	VARCHAR(64),
	SignMessage	BIT,
	CryptMessageAlgorithm	VARCHAR(64),
	AcceptServerCertCerFile	VARCHAR(64),
	SigningCertSubject	VARCHAR(64),
	SslClientCertSubject	VARCHAR(64),
	Timeout int,
	CONSTRAINT PKEY_AS2SendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class SmtpReceiveChannel
CREATE TABLE SmtpReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	RecipientValidation	INTEGER,
	DomainList	VARCHAR(2048),
	Authentification	INTEGER,
	ProxyBehaviour	INTEGER,
	SslHandling	INTEGER,
	SslServerCertPfxFile	VARCHAR(64),
	SslServerCertPfxPassword	VARCHAR(64),
	CONSTRAINT PKEY_SmtpReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class Pop3SendChannel
CREATE TABLE Pop3SendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	NotificationHash	INTEGER,
	UseSenderAddressAsFrom	BIT,
	MailFrom	VARCHAR(64),
	SendSingleAttachmentsAsBody	BIT,
	RequestNotification	INTEGER,
	SslHandling	INTEGER,
	SslServerCertPfxFile	VARCHAR(64),
	SslServerCertPfxPassword	VARCHAR(64),
	CONSTRAINT PKEY_Pop3SendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ChannelProxyEventListener
CREATE TABLE ChannelProxyEventListener (
	Oid	VARCHAR(36) NOT NULL,
	CoreEventListener_oid	VARCHAR(36),
	ChannelTypeName	VARCHAR(64),
	ListenUri	VARCHAR(64),
	UseListenUri	BIT,
	CONSTRAINT PKEY_ChannelProxyEventListener_Oid PRIMARY KEY (Oid));


-- create table for persistent class FilenameGenerator
CREATE TABLE FilenameGenerator (
	Oid	VARCHAR(36) NOT NULL,
	FilenameGeneration	INTEGER,
	FilenameMask	VARCHAR(256),
	UseBadCharReplacing	BIT,
	BadCharReplacingMethod	INTEGER,
	CONSTRAINT PKEY_FilenameGenerator_Oid PRIMARY KEY (Oid));


-- create table for persistent class FtpSendChannel
CREATE TABLE FtpSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	OutputPath	VARCHAR(256) NOT NULL,
	FileNameHandling	INTEGER,
	FileExistsHandling	INTEGER,
	Host	VARCHAR(64) NOT NULL,
	Port	INTEGER NOT NULL,
	Username	VARCHAR(64),
	Password	VARCHAR(64),
	UseTemporaryTransportFileName	BIT,
	TemporaryTransportFileName	VARCHAR(64),
	CONSTRAINT PKEY_FtpSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class FtpReceiveChannel
CREATE TABLE FtpReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	InputPath	VARCHAR(256) NOT NULL,
	InputFileMask	VARCHAR(64),
	Host	VARCHAR(64) NOT NULL,
	Port	INTEGER NOT NULL,
	Username	VARCHAR(64),
	Password	VARCHAR(64),
	DeleteAcceptedFiles	BIT,
	CONSTRAINT PKEY_FtpReceiveChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ArticleAttribute
CREATE TABLE ArticleAttribute (
	Oid	VARCHAR(36) NOT NULL,
	Location_oid	VARCHAR(36) NOT NULL,
	Type	INTEGER NOT NULL,
	Id	VARCHAR(64) NOT NULL,
	Text	VARCHAR(64),
	CONSTRAINT PKEY_ArticleAttribute_Oid PRIMARY KEY (Oid));


-- create table for persistent class CounterDef
CREATE TABLE CounterDef (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	_Public	BIT,
	FirstValue	INTEGER NOT NULL,
	Max	INTEGER NOT NULL,
	Increment	INTEGER NOT NULL,
	OverflowHandling	INTEGER,
	CONSTRAINT PKEY_CounterDef_Oid PRIMARY KEY (Oid));


-- create table for persistent class CounterValue
CREATE TABLE CounterValue (
	Oid	VARCHAR(36) NOT NULL,
	CounterDef_oid	VARCHAR(36) NOT NULL,
	RefName	VARCHAR(64) NOT NULL,
	CurrentValue	INTEGER NOT NULL,
	CONSTRAINT PKEY_CounterValue_Oid PRIMARY KEY (Oid));


-- create table for persistent class SubjectGenerator
CREATE TABLE SubjectGenerator (
	Oid	VARCHAR(36) NOT NULL,
	SubjectGeneration	INTEGER,
	SubjectMask	VARCHAR(256),
	CONSTRAINT PKEY_SubjectGenerator_Oid PRIMARY KEY (Oid));


-- create table for persistent class AnsiX12ReaderConfig
CREATE TABLE AnsiX12ReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	CONSTRAINT PKEY_AnsiX12ReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class AnsiX12WriterConfig
CREATE TABLE AnsiX12WriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_AnsiX12WriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class XmlReaderExConfig
CREATE TABLE XmlReaderExConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	UseOfAdditionalXmlRootTag BIT,
	CONSTRAINT PKEY_XmlReaderExConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class ShoeTransactionSendChannel
CREATE TABLE ShoeTransactionSendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	Url	VARCHAR(128) NOT NULL,
	AuthUserName	VARCHAR(64) NOT NULL,
	AuthPassword	VARCHAR(64) NOT NULL,
	TransactionType	VARCHAR(64),
	TimeoutSeconds	INTEGER,
	CONSTRAINT PKEY_ShoeTransactionSendChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ShoeTransactionResponseChannel
CREATE TABLE ShoeTransactionResponseChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	ImmediateCommit	BIT,
	CONSTRAINT PKEY_ShoeTransactionResponseChannel_Oid PRIMARY KEY (Oid));


-- create table for persistent class ediBoxInhouseReaderConfig
CREATE TABLE ediBoxInhouseReaderConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectReader_oid	VARCHAR(36),
	CONSTRAINT PKEY_ediBoxInhouseReaderConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class ediBoxInhouseWriterConfig
CREATE TABLE ediBoxInhouseWriterConfig (
	Oid	VARCHAR(36) NOT NULL,
	CoreObjectWriter_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_ediBoxInhouseWriterConfig_Oid PRIMARY KEY (Oid));


-- create table for persistent class VariableDefinition
CREATE TABLE VariableDefinition (
	Oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	Name	VARCHAR(64) NOT NULL,
	Type	INTEGER NOT NULL,
	Description	VARCHAR(256),
	DefaultValue	VARCHAR(256),
	IsSystemLocationBindable	BIT,
	IsTradingPartnerLocationBindable	BIT,
	LookupTableValueProvider_oid	VARCHAR(36),
	CONSTRAINT PKEY_VariableDefinition_Oid PRIMARY KEY (Oid));


-- create table for persistent class VariableInstance
CREATE TABLE VariableInstance (
	Oid	VARCHAR(36) NOT NULL,
	VariableDefinition_oid	VARCHAR(36) NOT NULL,
	Value	VARCHAR(256),
	Location_oid	VARCHAR(36),
	CONSTRAINT PKEY_VariableInstance_Oid PRIMARY KEY (Oid));


-- create table for persistent class AssemblySchemaVersion
CREATE TABLE AssemblySchemaVersion (
	Oid	VARCHAR(36) NOT NULL,
	AssemblyName	VARCHAR(64) NOT NULL,
	Version	VARCHAR(64),
	LastUpgrade	DATETIME,
	CONSTRAINT PKEY_AssemblySchemaVersion_Oid PRIMARY KEY (Oid));

-- create table for persistent class Reports
CREATE TABLE Reports (
	Oid	VARCHAR(36) NOT NULL,
	Name VARCHAR(64) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	EntryDate	DATETIME,
	LastChangeDate	DATETIME,
	ReportData	BLOB,
	Output VARCHAR(128),
	SourceType VARCHAR(128),
	CONSTRAINT PKEY_Reports_Oid PRIMARY KEY (Oid));

-- create table for persistent class ArticlePool
CREATE TABLE ArticlePool (
	Oid	VARCHAR(36) NOT NULL,
	Location_oid	VARCHAR(36) NOT NULL,
	Article_oid	VARCHAR(36) NOT NULL,
	Node_oid	VARCHAR(36) NOT NULL,
	EntryDate	DATETIME,
	LastChangeDate	DATETIME,
	LastSendDate	DATETIME,
	Deactivated	BIT,
	CONSTRAINT PKEY_ArticlePool_Oid PRIMARY KEY (Oid));


CREATE TABLE Preislinien (
	Oid	VARCHAR(36) NOT NULL,
	Bezeichnung	VARCHAR(64),
	Node_oid	VARCHAR(36) NOT NULL,
	PurchasePriceCurrency	VARCHAR(3),
	RetailPriceCurrency	VARCHAR(3),
	ParentPreislinie_oid	VARCHAR(36),
	Level	INTEGER DEFAULT -1,
	CONSTRAINT PKEY_Preislinien_Oid PRIMARY KEY (Oid));



CREATE TABLE PreislinienAbo (
	Oid	VARCHAR(36) NOT NULL,
	LocationOid	VARCHAR(36),
	CONSTRAINT PKEY_PreislinienAbo_Oid PRIMARY KEY (Oid));


CREATE TABLE ArticleDetailPreislinien (
	Oid	VARCHAR(36) NOT NULL,
	LocationOid	VARCHAR(36),
	ArticleDetail_oid	VARCHAR(36) NOT NULL,
	Preislinien_oid	VARCHAR(36) NOT NULL,
	EffectivePurchasePrice	INTEGER,
	ListPurchasePrice	INTEGER,
	ListPriceCurrency VARCHAR(3),
	PurchasePriceCurrency	VARCHAR(3),
	SuggestedRetailPrice	INTEGER,
	RetailPriceCurrency	VARCHAR(3),
	ModificationTime	DATETIME,
	CreateTime DATETIME,
	CONSTRAINT PKEY_ArticleDetailPreislinien_Oid PRIMARY KEY (Oid));


-- create table for persistent class ArticleEAN
CREATE TABLE ArticleEAN (
	Oid	VARCHAR(36) NOT NULL,
	ArticleDetail_oid	VARCHAR(36) NOT NULL,
	EAN	VARCHAR(64),
	LastChangeDate	DATETIME,
	CONSTRAINT PKEY_ArticleEAN_Oid PRIMARY KEY (Oid));


-- create table for persistent class X400SendChannel
CREATE TABLE X400SendChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),

	Country VARCHAR(10) NOT NULL,
	ADMD VARCHAR(64) NOT NULL,
	Organisation VARCHAR(64) NOT NULL,
	Surname VARCHAR(64) ,
	GivenName VARCHAR(64),
	Password VARCHAR(64),
	OrganisationalUnit1 VARCHAR(64),
	AdditionalX400Identifiers VARCHAR(256),
	CharSet VARCHAR(3),
	DeleteTemporaryDirectory BIT,

	CONSTRAINT PKEY_X400SendChannel_Oid PRIMARY KEY (Oid));

-- create table for persistent class X400ReceiveChannel
CREATE TABLE X400ReceiveChannel (
	Oid	VARCHAR(36) NOT NULL,
	CoreChannel_oid	VARCHAR(36),
	
	Country VARCHAR(10) NOT NULL,
	ADMD VARCHAR(64) NOT NULL,
	Organisation VARCHAR(64) NOT NULL,
	Surname VARCHAR(64) ,
	GivenName VARCHAR(64),
	Password VARCHAR(64),
	OrganisationalUnit1 VARCHAR(64),
	AdditionalX400Identifiers VARCHAR(256),
	CharSet VARCHAR(3),
	DeleteTemporaryDirectory BIT,
	FetchMask VARCHAR(64),

	CONSTRAINT PKEY_X400ReceiveChannel_Oid PRIMARY KEY (Oid));

CREATE TABLE ArticleDetailCustomItems (
	Oid	VARCHAR(36) NOT NULL,
	ArticleDetail_oid	VARCHAR(36),
	ItemKey VARCHAR(128),
	ItemValue VARCHAR(256),
	
	CONSTRAINT PKEY_ArticleDetailCustomItems_Oid PRIMARY KEY (Oid));


CREATE TABLE ArticleDetailArticleText (
	Oid	VARCHAR(36) NOT NULL,
	ArticleDetail_oid	VARCHAR(36),
	ArticleText varchar(256),
	ArticleShortText varchar(256),
	ColorDescription varchar(256),
	ProductGroup varchar(256),
	PartnerLanguage_oid VARCHAR(36),
	CONSTRAINT PKEY_ArticleDetailArticleText_Oid PRIMARY KEY (Oid));

CREATE TABLE PartnerLanguage (
	Oid	VARCHAR(36) NOT NULL,
	Sprache	varchar(36),
	Node_oid	VARCHAR(36) NOT NULL,
	CONSTRAINT PKEY_PartnerLanguage_Oid PRIMARY KEY (Oid));


-- end table-creation script part
CREATE INDEX Node_Auto_1 ON Node(ParentNode_oid);
CREATE INDEX Node_Auto_2 ON Node(DefaultSystemPartner_oid);
CREATE INDEX Node_Auto_3 ON Node(DefaultTemplatePartner_oid);
CREATE INDEX eBissUser_Auto_1 ON eBissUser(Node_oid);
CREATE INDEX AccessRight_Auto_1 ON AccessRight(Node_oid);
CREATE INDEX AccessRight_Auto_2 ON AccessRight(User_oid);
CREATE INDEX JobDef_Auto_1 ON JobDef(Node_oid);
CREATE INDEX JobDef_Auto_2 ON JobDef(Owner_oid);
CREATE INDEX JobDef_Auto_3 ON JobDef(LastModifiedBy_oid);
CREATE INDEX RuntimeSession_Auto_1 ON RuntimeSession(User_oid);
CREATE INDEX RuntimeSession_Auto_2 ON RuntimeSession(Node_oid);
CREATE INDEX AddressBase_Auto_1 ON AddressBase(Node_oid);
CREATE INDEX AddressBase_Auto_2 ON AddressBase(Partner_oid);
CREATE INDEX TypeSet_AddressBase_Auto_1 ON TypeSet_AddressBase(TypeSet_oid);
CREATE INDEX TypeSet_AddressBase_Auto_2 ON TypeSet_AddressBase(AddressBase_oid);
CREATE INDEX MessageBox_Auto_1 ON MessageBox(Node_oid);

CREATE INDEX Message_Manual_lookUpAutoIndex0 ON Message(Subject);
CREATE INDEX Message_Manual_lookUpAutoIndex1 ON Message(ComRef);
CREATE INDEX Message_Manual_lookUpAutoIndex2 ON Message(EntryDate);
CREATE INDEX Message_Auto_1 ON Message(DelegatedJob_oid);
CREATE INDEX Message_Auto_2 ON Message(MessageBox_oid);
CREATE INDEX Message_Auto_3 ON Message(OwnLocation_oid);
CREATE INDEX Message_Auto_4 ON Message(Partner_oid);

CREATE INDEX Message_Manual_1_State ON Message(State);


CREATE INDEX ProcessInstance_Message_Auto_1 ON ProcessInstance_Message(ProcessInstance_oid);
CREATE INDEX ProcessInstance_Message_Auto_2 ON ProcessInstance_Message(Message_oid);
CREATE INDEX Attachment_Auto_1 ON Attachment(Message_oid);
CREATE INDEX Attachment_Auto_2 ON Attachment(EntityAnalyzer_oid);
CREATE INDEX Interchange_Auto_1 ON Interchange(Attachment_oid);
CREATE INDEX Interchange_Auto_2 ON Interchange(Partner_oid);
CREATE INDEX Interchange_Auto_3 ON Interchange(OwnLocation_oid);
CREATE INDEX Document_Auto_1 ON Document(Interchange_oid);
CREATE INDEX Document_Auto_2 ON Document(Message_oid);
CREATE INDEX Document_Auto_3 ON Document(EntityType_oid);
CREATE INDEX Document_Auto_4 ON Document(OriginDocument_oid);
CREATE INDEX Document_Auto_5 ON Document(SystemLocation_oid);
CREATE INDEX Document_Auto_6 ON Document(PartnerLocation_oid);
CREATE INDEX MapDef_Auto_1 ON MapDef(Node_oid);
CREATE INDEX MapDef_Auto_2 ON MapDef(Owner_oid);
CREATE INDEX MapDef_Auto_3 ON MapDef(LastModifiedBy_oid);
CREATE INDEX LookupTableType_Auto_1 ON LookupTableType(Node_oid);
CREATE INDEX LookupTableType_Auto_2 ON LookupTableType(ValueProvider_oid);
CREATE INDEX LookupTable_Auto_1 ON LookupTable(LookupTableType_oid);
CREATE INDEX LookupTableEntry_Auto_1 ON LookupTableEntry(LookupTable_oid);
CREATE INDEX LookupTableEntry_Manual_lookUpAutoIndex0 ON LookupTableEntry(_Key);
CREATE INDEX LookupTableEntry_Manual_lookUpAutoIndex2 ON LookupTableEntry(Description);
CREATE INDEX LookupTableEntry_Auto_2 ON LookupTableEntry(ValueEntry_oid);
CREATE INDEX LookupTableValueProvider_Manual_lookUpAutoIndex0 ON LookupTableValueProvider(BackendLookupProviderTypeName);
CREATE INDEX LookupTableValueProvider_Auto_1 ON LookupTableValueProvider(Node_oid);
CREATE INDEX LookupTableValueProvider_Manual_lookUpAutoIndex2 ON LookupTableValueProvider(BackendLookupProviderReference);
CREATE INDEX LookupTableValueProviderEntry_Auto_1 ON LookupTableValueProviderEntry(ValueProvider_oid);
CREATE INDEX LookupTableValueProviderEntry_Manual_lookUpAutoIndex0 ON LookupTableValueProviderEntry(Val);
CREATE INDEX LookupTableValueProviderEntry_Manual_lookUpAutoIndex2 ON LookupTableValueProviderEntry(Description);
CREATE INDEX Partner_Manual_lookUpAutoIndex0 ON Partner(Name);
CREATE INDEX Partner_Manual_lookUpAutoIndex3 ON Partner(TNr);
CREATE INDEX Partner_Auto_1 ON Partner(Channel_oid);
CREATE INDEX Partner_Auto_2 ON Partner(Containerizer_oid);
CREATE INDEX Partner_Auto_3 ON Partner(MainLocation_oid);
CREATE INDEX Partner_Auto_4 ON Partner(Node_oid);
CREATE INDEX Partner_Auto_5 ON Partner(Template_oid);
CREATE INDEX Article_Manual_ArticleNumber ON Article(ArticleNumber);
CREATE INDEX Article_Auto_1 ON Article(Node_oid);
CREATE INDEX Article_Auto_2 ON Article(Location_oid);
CREATE INDEX ArticleDetail_Auto_1 ON ArticleDetail(Article_oid);
CREATE INDEX ArticleDetail_Manual_lookUpAutoIndex0 ON ArticleDetail(ArticleDescription);
CREATE INDEX ArticleDetail_Manual_iArticleNumber ON ArticleDetail(ArticleNumber);
CREATE INDEX ArticleDetail_Manual_lookUpAutoIndex2 ON ArticleDetail(ArticleNumber);
CREATE INDEX ArticleDetail_Manual_iEan ON ArticleDetail(Ean);
CREATE INDEX ArticleDetail_Auto_2 ON ArticleDetail(Node_oid);
CREATE INDEX ArticleDetail_Auto_3 ON ArticleDetail(ColorAttribute_oid);
CREATE INDEX ArticleDetail_Auto_4 ON ArticleDetail(SizeAttribute_oid);
CREATE INDEX ArticleDetail_Auto_5 ON ArticleDetail(ProductGroupAttribute_oid);
CREATE INDEX DocMatch_Auto_1 ON DocMatch(Partner_oid);
CREATE INDEX DocMatch_Auto_2 ON DocMatch(StandardMapping_oid);
CREATE INDEX DocMatch_Auto_3 ON DocMatch(SpecialMapping_oid);
CREATE INDEX ArticleSubscription_Auto_1 ON ArticleSubscription(Node_oid);
CREATE INDEX ArticleSubscription_Auto_2 ON ArticleSubscription(Location_oid);
CREATE INDEX Task_Auto_1 ON Task(Node_oid);
CREATE INDEX Task_Auto_2 ON Task(ResponsibleUser_oid);
CREATE INDEX Task_Auto_3 ON Task(ProcessInstance_oid);
CREATE INDEX Task_Auto_4 ON Task(ResolvObjectReference_oid);
CREATE INDEX Task_ObjectReference_Auto_1 ON Task_ObjectReference(Task_oid);
CREATE INDEX Task_ObjectReference_Auto_2 ON Task_ObjectReference(ObjectReference_oid);
CREATE INDEX ProcessInstance_Auto_1 ON ProcessInstance(Node_oid);
CREATE INDEX ProcessInstance_Auto_2 ON ProcessInstance(RuntimeSession_oid);
CREATE INDEX ScheduleEvent_Auto_1 ON ScheduleEvent(CoreEventListener_oid);
CREATE INDEX ScheduleTime_Auto_1 ON ScheduleTime(ScheduleEvent_oid);
CREATE INDEX PortEventListener_Auto_1 ON PortEventListener(CoreEventListener_oid);
CREATE INDEX CoreEventListener_Auto_1 ON CoreEventListener(JobDef_oid);
CREATE INDEX CoreEventListener_Auto_2 ON CoreEventListener(Node_oid);
CREATE INDEX CoreEventListener_Auto_3 ON CoreEventListener(User_oid);
CREATE INDEX PortAccessRule_Auto_1 ON PortAccessRule(PortEventListener_oid);
CREATE INDEX CoreChannel_Auto_1 ON CoreChannel(Node_oid);
CREATE INDEX CoreChannel_Auto_2 ON CoreChannel(MessageBox_oid);
CREATE INDEX CoreChannel_Auto_3 ON CoreChannel(DefaultSender_oid);
CREATE INDEX CoreChannel_Auto_4 ON CoreChannel(DefaultRecipient_oid);
CREATE INDEX HttpReceiveChannel_Auto_1 ON HttpReceiveChannel(CoreChannel_oid);
CREATE INDEX TypeRepository_Auto_1 ON TypeRepository(Node_oid);
CREATE INDEX FileTypeRecognizer_Auto_1 ON FileTypeRecognizer(TypeRepository_oid);
CREATE INDEX EntityAnalyzer_Auto_1 ON EntityAnalyzer(Repository_oid);
CREATE INDEX EntityAnalyzer_Auto_2 ON EntityAnalyzer(Recognizer_oid);
CREATE INDEX EntityAnalyzer_Manual_lookUpAutoIndex1 ON EntityAnalyzer(ObjectReaderTypeName);
CREATE INDEX EntityAnalyzer_Auto_3 ON EntityAnalyzer(CoreObjectReader_oid);
CREATE INDEX EntityAnalyzer_EntityType_Auto_1 ON EntityAnalyzer_EntityType(EntityAnalyzer_oid);
CREATE INDEX EntityAnalyzer_EntityType_Auto_2 ON EntityAnalyzer_EntityType(EntityType_oid);
CREATE INDEX EntityType_Auto_1 ON EntityType(Repository_oid);
CREATE INDEX EntityType_Manual_EntityTypeName ON EntityType(EntityTypeName);
CREATE INDEX EntityType_Manual_lookUpAutoIndex1 ON EntityType(EntityTypeName);
CREATE INDEX EntityType_Auto_2 ON EntityType(DefaultContainerizer_oid);
CREATE INDEX EntityType_Auto_3 ON EntityType(DefaultObjectWriter_oid);
CREATE INDEX EntityType_Auto_4 ON EntityType(DefaultObjectReader_oid);
CREATE INDEX EntityContainerizer_Auto_1 ON EntityContainerizer(Repository_oid);
CREATE INDEX EntityContainerizer_Manual_lookUpAutoIndex1 ON EntityContainerizer(ContainerizerTypeName);
CREATE INDEX EntityContainerizer_Auto_2 ON EntityContainerizer(CoreObjectWriter_oid);
CREATE INDEX TypeSet_Auto_1 ON TypeSet(Partner_oid);
CREATE INDEX TypeSet_Auto_2 ON TypeSet(Type_oid);
CREATE INDEX TypeSet_Auto_3 ON TypeSet(TargetType_oid);
CREATE INDEX TypeSet_Auto_4 ON TypeSet(CoreChannel_oid);
CREATE INDEX TypeSet_Auto_5 ON TypeSet(EntityContainerizer_oid);
CREATE INDEX TypeSet_Auto_6 ON TypeSet(Mapping_oid);
CREATE INDEX HttpSendChannel_Auto_1 ON HttpSendChannel(CoreChannel_oid);
CREATE INDEX ediBOXReceiveChannel_Auto_1 ON ediBOXReceiveChannel(CoreChannel_oid);
CREATE INDEX ediBOXSendChannel_Auto_1 ON ediBOXSendChannel(CoreChannel_oid);
CREATE INDEX FileEventListener_Auto_1 ON FileEventListener(CoreEventListener_oid);
CREATE INDEX Pop3ReceiveChannel_Auto_1 ON Pop3ReceiveChannel(CoreChannel_oid);
CREATE INDEX CoreObjectReader_Auto_1 ON CoreObjectReader(Repository_oid);
CREATE INDEX EdifactReaderConfig_Auto_1 ON EdifactReaderConfig(CoreObjectReader_oid);
CREATE INDEX SdfReaderConfig_Auto_1 ON SdfReaderConfig(CoreObjectReader_oid);
CREATE INDEX HarddiskSendChannel_Auto_1 ON HarddiskSendChannel(CoreChannel_oid);
CREATE INDEX HarddiskReceiveChannel_Auto_1 ON HarddiskReceiveChannel(CoreChannel_oid);
CREATE INDEX SmtpSendChannel_Auto_1 ON SmtpSendChannel(CoreChannel_oid);
CREATE INDEX FixedLengthReaderConfig_Auto_1 ON FixedLengthReaderConfig(CoreObjectReader_oid);
CREATE INDEX XmlReaderConfig_Auto_1 ON XmlReaderConfig(CoreObjectReader_oid);
CREATE INDEX CoreObjectWriter_Auto_1 ON CoreObjectWriter(Repository_oid);
CREATE INDEX EdifactWriterConfig_Auto_1 ON EdifactWriterConfig(CoreObjectWriter_oid);
CREATE INDEX SdfWriterConfig_Auto_1 ON SdfWriterConfig(CoreObjectWriter_oid);
CREATE INDEX FixedLengthWriterConfig_Auto_1 ON FixedLengthWriterConfig(CoreObjectWriter_oid);
CREATE INDEX XmlWriterConfig_Auto_1 ON XmlWriterConfig(CoreObjectWriter_oid);
CREATE INDEX SapIDocWriterConfig_Auto_1 ON SapIDocWriterConfig(CoreObjectWriter_oid);
CREATE INDEX SapIDocReaderConfig_Auto_1 ON SapIDocReaderConfig(CoreObjectReader_oid);
CREATE INDEX Location_Auto_1 ON Location(Partner_oid);
CREATE INDEX Location_Auto_2 ON Location(BackendReference_oid);
CREATE INDEX Location_Auto_3 ON Location(Node_oid);
CREATE INDEX LocationLookup_Auto_1 ON LocationLookup(Location_oid);
CREATE INDEX LocationLookup_Auto_2 ON LocationLookup(TableType_oid);
CREATE INDEX LocationLookup_Auto_3 ON LocationLookup(Table_oid);
CREATE INDEX AS2ReceiveChannel_Auto_1 ON AS2ReceiveChannel(CoreChannel_oid);
CREATE INDEX AS2SendChannel_Auto_1 ON AS2SendChannel(CoreChannel_oid);
CREATE INDEX SmtpReceiveChannel_Auto_1 ON SmtpReceiveChannel(CoreChannel_oid);
CREATE INDEX Pop3SendChannel_Auto_1 ON Pop3SendChannel(CoreChannel_oid);
CREATE INDEX ChannelProxyEventListener_Auto_1 ON ChannelProxyEventListener(CoreEventListener_oid);
CREATE INDEX FtpSendChannel_Auto_1 ON FtpSendChannel(CoreChannel_oid);
CREATE INDEX FtpReceiveChannel_Auto_1 ON FtpReceiveChannel(CoreChannel_oid);
CREATE INDEX ArticleAttribute_Auto_1 ON ArticleAttribute(Location_oid);
CREATE INDEX CounterDef_Auto_1 ON CounterDef(Node_oid);
CREATE INDEX CounterDef_Manual_lookUpAutoIndex1 ON CounterDef(Name);
CREATE INDEX CounterValue_Auto_1 ON CounterValue(CounterDef_oid);
CREATE INDEX AnsiX12ReaderConfig_Auto_1 ON AnsiX12ReaderConfig(CoreObjectReader_oid);
CREATE INDEX AnsiX12WriterConfig_Auto_1 ON AnsiX12WriterConfig(CoreObjectWriter_oid);
CREATE INDEX XmlReaderExConfig_Auto_1 ON XmlReaderExConfig(CoreObjectReader_oid);
CREATE INDEX ShoeTransactionSendChannel_Auto_1 ON ShoeTransactionSendChannel(CoreChannel_oid);
CREATE INDEX ShoeTransactionResponseChannel_Auto_1 ON ShoeTransactionResponseChannel(CoreChannel_oid);
CREATE INDEX ediBoxInhouseReaderConfig_Auto_1 ON ediBoxInhouseReaderConfig(CoreObjectReader_oid);
CREATE INDEX ediBoxInhouseWriterConfig_Auto_1 ON ediBoxInhouseWriterConfig(CoreObjectWriter_oid);
CREATE INDEX VariableDefinition_Auto_1 ON VariableDefinition(Node_oid);
CREATE INDEX VariableDefinition_Auto_2 ON VariableDefinition(LookupTableValueProvider_oid);
CREATE INDEX VariableInstance_Auto_1 ON VariableInstance(VariableDefinition_oid);
CREATE INDEX VariableInstance_Auto_2 ON VariableInstance(Location_oid);
CREATE INDEX ArticlePool_Auto_1 ON ArticlePool(Location_oid);
CREATE INDEX ArticlePool_Auto_2 ON ArticlePool(Article_oid);
CREATE INDEX ArticlePool_Auto_3 ON ArticlePool(Node_oid);
CREATE INDEX ArticleEAN_Auto_1 ON ArticleEAN(ArticleDetail_oid);

CREATE INDEX X400SendChannel_Auto_1 ON X400SendChannel(CoreChannel_oid);
CREATE INDEX X400ReceiveChannel_Auto_1 ON X400ReceiveChannel(CoreChannel_oid);
